/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CSharedMemory.cpp,v 1.1 1999/09/12 04:29:49 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"
#include "CSharedMemory.h"

_USING_PGP

// Class CSharedMemory member functions

CSharedMemory::CSharedMemory() : 
	mIsAttached(FALSE), mHandle(NULL), mPtr(NULL)
{
}

CSharedMemory::~CSharedMemory()
{
	try
	{
		Clear();
	}
	catch (CComboError&) { }
}

void 
CSharedMemory::Attach(const char *name)
{
	pgpAssert(!IsAttached());
	pgpAssertStrValid(name);

	// Open the shared memory object.
	mHandle = OpenFileMapping(FILE_MAP_ALL_ACCESS, FALSE, name);

	if (IsNull(mHandle))
		THROW_ERRORS(kPGPError_MemoryOpFailed, GetLastError());

	try
	{
		// Map a view of the shared memory.
		mPtr = MapViewOfFile(mHandle, FILE_MAP_ALL_ACCESS, 0, 0, 0);

		if (IsNull(mPtr))
			THROW_ERRORS(kPGPError_MemoryOpFailed, GetLastError());

		mName = name;
		mIsAttached = TRUE;
	}
	catch (CComboError&)
	{
		CloseHandle(mHandle);
		mHandle = NULL;

		throw;
	}
}

void 
CSharedMemory::CreateAttach(const char *name, PGPUInt32 nBytes)
{
	pgpAssert(!IsAttached());
	pgpAssertStrValid(name);

	// Create the file mapping for the memory.
	mHandle = CreateFileMapping(reinterpret_cast<HANDLE>(0xFFFFFFFF), NULL, 
		PAGE_READWRITE, 0, nBytes, name);

	if (IsNull(mHandle))
		THROW_ERRORS(kPGPError_MemoryOpFailed, GetLastError());

	try
	{
		// Map a view of the shared memory.
		mPtr = MapViewOfFile(mHandle, FILE_MAP_ALL_ACCESS, 0, 0, 0);

		if (IsNull(mPtr))
			THROW_ERRORS(kPGPError_MemoryOpFailed, GetLastError());

		// Wipe if didn't already exist.
		if (GetLastError() != ERROR_ALREADY_EXISTS)
			pgpClearMemory(mPtr, nBytes);

		try
		{
			mName = name;
			mIsAttached = TRUE;
		}
		catch (CComboError&)
		{
			UnmapViewOfFile(mPtr);
			mPtr = NULL;

			throw;
		}
	}
	catch (CComboError&)
	{
		CloseHandle(mHandle);
		mHandle = NULL;

		throw;
	}
}

void 
CSharedMemory::Clear()
{
	if (IsAttached())
	{
		if (!UnmapViewOfFile(mPtr))
		{
			pgpAssert(FALSE);
		}

		if (!CloseHandle(mHandle))
		{
			pgpAssert(FALSE);
		}
	}

	mIsAttached = FALSE;

	mName.Empty();
	mHandle = NULL;
	mPtr = NULL;
}
